/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.event;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.FleeableBattleActor;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.StreamSupport;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.battle.battleactor.EntityBackedTrainerBattleActor;
import kiwiapollo.cobblemontrainerbattle.battle.trainerbattle.TrainerBattle;
import kiwiapollo.cobblemontrainerbattle.entity.TrainerEntity;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContextStorage;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class TrainerBattleFledEventHandler
implements ServerTickEvents.EndWorldTick {
    public void onEndTick(class_3218 world) {
        world.method_18456().forEach(player -> {
            try {
                this.endFledTrainerBattle((class_3222)player);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    private void endFledTrainerBattle(class_3222 player) {
        TrainerBattle trainerBattle = BattleContextStorage.getInstance().getOrCreate(player.method_5667()).getTrainerBattle();
        PokemonBattle pokemonBattle = Cobblemon.INSTANCE.getBattleRegistry().getBattle(trainerBattle.getBattleId());
        if (!this.isFledBattle(pokemonBattle, player)) {
            return;
        }
        StreamSupport.stream(pokemonBattle.getActors().spliterator(), false).filter(battleActor -> battleActor instanceof EntityBackedTrainerBattleActor).map(battleActor -> (EntityBackedTrainerBattleActor)((Object)battleActor)).map(EntityBackedTrainerBattleActor::getEntity).filter(Objects::nonNull).filter(entity -> entity instanceof TrainerEntity).forEach(entity -> ((TrainerEntity)((Object)entity)).method_5977(false));
        pokemonBattle.end();
        CobblemonTrainerBattle.LOGGER.info("Battle was fled: {}", (Object)player.method_7334().getName());
    }

    private boolean isFledBattle(PokemonBattle trainerBattle, class_3222 player) {
        try {
            FleeableBattleActor trainerBattleActor = StreamSupport.stream(trainerBattle.getActors().spliterator(), false).filter(battleActor -> battleActor instanceof FleeableBattleActor).map(battleActor -> (FleeableBattleActor)battleActor).findFirst().get();
            class_243 playerPos = player.method_19538();
            class_243 trainerPos = (class_243)trainerBattleActor.getWorldAndPosition().getSecond();
            return playerPos.method_1022(trainerPos) > (double)trainerBattleActor.getFleeDistance();
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException e) {
            return false;
        }
    }
}

